package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import com.ejie.p06b.datatype.model.P06B82T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * Fecha de creacin: (15/01/2010)
 */
public class P06B82T00DAO {
	
	static private P06B82T00DAO instance = null;

	public static P06B82T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B82T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B82T00DAO();
	                }
	          }
	     }
	     return instance;
	}
	
	/**
    * Obtiene la lista de documentos asociados al expediente
    * @param expediente.       
    * @return Lista de objetos de documentos
	 * @throws Exception
    */
	public ArrayList selectDocsTramitaguneAP(String expediente, int nCorrelAtencionPeticionAnadirDocs, String idioma) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B82T00Datatype-selectAllByExp");
		ArrayList lista = new ArrayList();
		P06B82T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_EXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,idioma);
        	lstm.setInt(2,nCorrelAtencionPeticionAnadirDocs);
        	lstm.setInt(3,nCorrelAtencionPeticionAnadirDocs);
        	lstm.setString(4,idioma);
        	
        	lrst = lstm.executeQuery();
	        while (lrst.next()) {
	    		
	        	obj = new P06B82T00Datatype();
	        	obj.setFechaHora(P06BFecha.getFechaHoraFormateadaFromIdioma(lrst.getTimestamp(P06BTablas.P06B_P06B64_AP_FECHA), idioma));
			    obj.setRoleIdEnPid(lrst.getString(P06BTablas.P06B_P06B82_DM_ROLEIDPIDFICHERO));
			    obj.setRoleNameCasEnPid(lrst.getString(P06BTablas.P06B_P06B82_DM_ROLENAMECASPIDFICHERO));
			    obj.setRoleNameEusEnPid(lrst.getString(P06BTablas.P06B_P06B82_DM_ROLENAMEEUSPIDFICHERO));
			    obj.setRoleNameEnPidIdiomaActivo(lrst.getString("P06B_P06B82_DM_ROLENAMEIDIACT"));
			    obj.setReferenciaEnPid(lrst.getString(P06BTablas.P06B_P06B82_DM_CODPIDFICHERO));
			    obj.setNombreEnPid(lrst.getString(P06BTablas.P06B_P06B82_DM_NOMBREFICHERO));
			    obj.setExtensionEnPid(lrst.getString(P06BTablas.P06B_P06B82_DM_EXTENSIONFICHERO));
			    
	        	lista.add(obj);
	        }
			lrst.close();
    		lstm.close();
    		lconConexion.close();
	        P06BLog.send(2,this, "Fin P06B82T00Datatype-selectAllByExp");
	    }catch (SQLException SQLe) {
	    	P06BLog.send(2, this, SQLe.getMessage());
	    	throw(SQLe);
	    }
		return lista;
	}

	
	private static String SELECTALL_BY_EXP =
		"SELECT " +
		P06BTablas.P06B_P06B64_AP_FECHA + "," +
		P06BTablas.P06B_P06B82_DM_ROLEIDPIDFICHERO + "," +
		P06BTablas.P06B_P06B82_DM_ROLENAMECASPIDFICHERO + "," +
		P06BTablas.P06B_P06B82_DM_ROLENAMEEUSPIDFICHERO + "," +
		"DECODE(?, '" + P06BConstantes.P06B_IDIOMA_EU + "'," + P06BTablas.P06B_P06B82_DM_ROLENAMEEUSPIDFICHERO + "," + P06BTablas.P06B_P06B82_DM_ROLENAMECASPIDFICHERO + ") AS P06B_P06B82_DM_ROLENAMEIDIACT, " +
		P06BTablas.P06B_P06B82_DM_CODPIDFICHERO + "," +
		P06BTablas.P06B_P06B82_DM_NOMBREFICHERO + "," +
		P06BTablas.P06B_P06B82_DM_EXTENSIONFICHERO +
		" FROM " + P06BTablas.P06B_P06B64T00_TABLA + ", " + P06BTablas.P06B_P06B82T00_TABLA 
		+ " WHERE " + P06BTablas.P06B_P06B82_DM_CORRELATENCPETIC + "= ? AND "
		+ P06BTablas.P06B_P06B64_AP_CORRELATENCPETIC + "= ?"
		+ " ORDER BY DECODE(?, '" + P06BConstantes.P06B_IDIOMA_EU + "'," + P06BTablas.P06B_P06B82_DM_ROLENAMEEUSPIDFICHERO + "," + P06BTablas.P06B_P06B82_DM_ROLENAMECASPIDFICHERO + "), " +
		P06BTablas.P06B_P06B64_AP_FECHA + " DESC";	

}
